/**
 *
 THIS PROGRAM WAS DEVELOPED FOR THE EXCLUSIVE USE OF:

MOUSER ELECTRONICS
1000 NORTH MAIN STREET
MANSFIELD TEXAS
 *
 *
WRITTEN BY:  RYAN L. PREWITT
COMPILED: June 16, 2015
 *
 *
  Generated Main Source File

  File Name:
    main.c

  Summary:
    This is the controller main.c program for the Mouser LED Game

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  MPLAB Code Configurator - v2.0.1
        Device            :  PIC16F1829
        Driver Version    :  2.00
    The generated drivers are tested against the following:
        Compiler          :  XC8 v1.31
        MPLAB             :  MPLAB X 2.10
*/

/*
Beginning of File
*/

#include "mcc_generated_files/mcc.h"
#include <xc.h>
//
//
// DEFINE POSITION DATA GENERAL PURPOSE BITFIELD //

volatile unsigned char           POS_Data               @ 0x020;
// bit and bitfield definitions
volatile bit POS_Data0                 @ ((unsigned)&POS_Data*8)+0;
volatile bit POS_Data1                 @ ((unsigned)&POS_Data*8)+1;
volatile bit POS_Data2                 @ ((unsigned)&POS_Data*8)+2;
volatile bit POS_Data3                 @ ((unsigned)&POS_Data*8)+3;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	                    : 4;
        unsigned    POS_Data0                : 1;
        unsigned	POS_Data1                : 1;
        unsigned	POS_Data2                : 1;
        unsigned	POS_Data3                : 1;
    };
} POS_Databits @ 0x020;
#endif

#define __delay_us(x) _delay((unsigned long)((x)*(_XTAL_FREQ/4000000.0)))
#define __delay_ms(x) _delay((unsigned long)((x)*(_XTAL_FREQ/4000.0)))
#define UP POS_Data0
#define DOWN POS_Data1
#define LEFT POS_Data2
#define RIGHT POS_Data3
#define START RA4
#define START_OUT RC4

//16 BITS OF AD REGISTER IS FFFF = 65535 ( Divided by 2 = 32767 )
unsigned int buffermax = 35367; //32767 + 2500
unsigned int buffermin = 30267; //32767 - 2500
unsigned int ADCResult[2]={};

/*
Main application
 */
void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    while (1)
    {
    if (START == 1)
        {
        __delay_ms(2);
        if (START == 1)
            {
            START_OUT = 1;
            __delay_ms(10);
            START_OUT = 0;
            }
        }

    for (unsigned char i = 0; i <=1; i++)
        {
        ADCON0bits.CHS=i;
        ADCON0bits.GO = 1;
        while(ADCON0bits.GO==1){};
        ADCResult[i]= (ADRESH<<8)+ADRESL;
        __delay_ms(2);
        }
    POS_Data = 0;

    if (ADCResult[0] > buffermax)
       {
       UP = 1;
       }
       else
       {
       UP = 0;
       }
    if (ADCResult[0] < buffermin)
       {
       DOWN = 1;
       }
       else
       {
       DOWN = 0;
       }

    if (ADCResult[1] > buffermax)
       {
       RIGHT = 1;
       }
       else
       {
       RIGHT = 0;
       }

    if (ADCResult[1] < buffermin)
       {
       LEFT = 1;
       }
       else
       {
       LEFT = 0;
       }

        switch(POS_Data)
        {
            case 0:
                RC0 = 0;
                RC1 = 0;
                RC2 = 0;
                RC3 = 0;
                break;

            case 1:
                RC0 = 1;
                RC1 = 0;
                RC2 = 0;
                RC3 = 0;
                break;

            case 2:
                RC0 = 0;
                RC1 = 1;
                RC2 = 0;
                RC3 = 0;
                break;

            case 4:
                RC0 = 0;
                RC1 = 0;
                RC2 = 1;
                RC3 = 0;
                break;

            case 8:
                RC0 = 0;
                RC1 = 0;
                RC2 = 0;
                RC3 = 1;
                break;

            case 5:
                if ( (ADCResult[0] - 32767) > (32767 - ADCResult[1]) )
                {
                RC0 = 1;
                RC1 = 0;
                RC2 = 0;
                RC3 = 0;
                }
                else
                {
                RC0 = 0;
                RC1 = 0;
                RC2 = 1;
                RC3 = 0;
                }
                break;

             case 9:
                if ( (ADCResult[0] - 32767) > (ADCResult[1]- 32767) )
                {
                RC0 = 1;
                RC1 = 0;
                RC2 = 0;
                RC3 = 0;
                }
                else
                {
                RC0 = 0;
                RC1 = 0;
                RC2 = 0;
                RC3 = 1;
                }
                break;

             case 6:
                if ( (32767 - ADCResult[0]) > (32767 - ADCResult[1]) )
                {
                RC0 = 0;
                RC1 = 1;
                RC2 = 0;
                RC3 = 0;
                }
                else
                {
                RC0 = 0;
                RC1 = 0;
                RC2 = 1;
                RC3 = 0;
                }
                break;

            case 10:
                if ( (32767 - ADCResult[0]) > (ADCResult[1] - 32767) )
                {
                RC0 = 0;
                RC1 = 1;
                RC2 = 0;
                RC3 = 0;
                }
                else
                {
                RC0 = 0;
                RC1 = 0;
                RC2 = 0;
                RC3 = 1;
                }
                break;
    }
    }
}
/*
 End of File
*/