/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using MPLAB Code Configurator

  @Description:
    This header file provides implementations for pin APIs for all pins selected in the GUI.
    Generation Information :
        Product Revision  :  MPLAB Code Configurator - v2.25
        Device            :  PIC16F1829
        Version           :  1.01
    The generated drivers are tested against the following:
        Compiler          :  XC8 v1.34
        MPLAB             :  MPLAB X v2.35 or v3.00
*/

/*
Copyright (c) 2013 - 2015 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set channel_AN0 aliases
#define channel_AN0_TRIS               TRISA0
#define channel_AN0_LAT                LATA0
#define channel_AN0_PORT               RA0
#define channel_AN0_WPU                WPUA0
#define channel_AN0_ANS                ANSA0
#define channel_AN0_SetHigh()    do { LATA0 = 1; } while(0)
#define channel_AN0_SetLow()   do { LATA0 = 0; } while(0)
#define channel_AN0_Toggle()   do { LATA0 = ~LATA0; } while(0)
#define channel_AN0_GetValue()         RA0
#define channel_AN0_SetDigitalInput()    do { TRISA0 = 1; } while(0)
#define channel_AN0_SetDigitalOutput()   do { TRISA0 = 0; } while(0)

#define channel_AN0_SetPullup()    do { WPUA0 = 1; } while(0)
#define channel_AN0_ResetPullup()   do { WPUA0 = 0; } while(0)
#define channel_AN0_SetAnalogMode()   do { ANSA0 = 1; } while(0)
#define channel_AN0_SetDigitalMode()   do { ANSA0 = 0; } while(0)
// get/set channel_AN1 aliases
#define channel_AN1_TRIS               TRISA1
#define channel_AN1_LAT                LATA1
#define channel_AN1_PORT               RA1
#define channel_AN1_WPU                WPUA1
#define channel_AN1_ANS                ANSA1
#define channel_AN1_SetHigh()    do { LATA1 = 1; } while(0)
#define channel_AN1_SetLow()   do { LATA1 = 0; } while(0)
#define channel_AN1_Toggle()   do { LATA1 = ~LATA1; } while(0)
#define channel_AN1_GetValue()         RA1
#define channel_AN1_SetDigitalInput()    do { TRISA1 = 1; } while(0)
#define channel_AN1_SetDigitalOutput()   do { TRISA1 = 0; } while(0)

#define channel_AN1_SetPullup()    do { WPUA1 = 1; } while(0)
#define channel_AN1_ResetPullup()   do { WPUA1 = 0; } while(0)
#define channel_AN1_SetAnalogMode()   do { ANSA1 = 1; } while(0)
#define channel_AN1_SetDigitalMode()   do { ANSA1 = 0; } while(0)
// get/set SW_IN aliases
#define SW_IN_TRIS               TRISA5
#define SW_IN_LAT                LATA5
#define SW_IN_PORT               RA5
#define SW_IN_WPU                WPUA5
#define SW_IN_SetHigh()    do { LATA5 = 1; } while(0)
#define SW_IN_SetLow()   do { LATA5 = 0; } while(0)
#define SW_IN_Toggle()   do { LATA5 = ~LATA5; } while(0)
#define SW_IN_GetValue()         RA5
#define SW_IN_SetDigitalInput()    do { TRISA5 = 1; } while(0)
#define SW_IN_SetDigitalOutput()   do { TRISA5 = 0; } while(0)

#define SW_IN_SetPullup()    do { WPUA5 = 1; } while(0)
#define SW_IN_ResetPullup()   do { WPUA5 = 0; } while(0)
// get/set UP_Out aliases
#define UP_Out_TRIS               TRISC0
#define UP_Out_LAT                LATC0
#define UP_Out_PORT               RC0
#define UP_Out_WPU                WPUC0
#define UP_Out_ANS                ANSC0
#define UP_Out_SetHigh()    do { LATC0 = 1; } while(0)
#define UP_Out_SetLow()   do { LATC0 = 0; } while(0)
#define UP_Out_Toggle()   do { LATC0 = ~LATC0; } while(0)
#define UP_Out_GetValue()         RC0
#define UP_Out_SetDigitalInput()    do { TRISC0 = 1; } while(0)
#define UP_Out_SetDigitalOutput()   do { TRISC0 = 0; } while(0)

#define UP_Out_SetPullup()    do { WPUC0 = 1; } while(0)
#define UP_Out_ResetPullup()   do { WPUC0 = 0; } while(0)
#define UP_Out_SetAnalogMode()   do { ANSC0 = 1; } while(0)
#define UP_Out_SetDigitalMode()   do { ANSC0 = 0; } while(0)
// get/set DOWN_Out aliases
#define DOWN_Out_TRIS               TRISC1
#define DOWN_Out_LAT                LATC1
#define DOWN_Out_PORT               RC1
#define DOWN_Out_WPU                WPUC1
#define DOWN_Out_ANS                ANSC1
#define DOWN_Out_SetHigh()    do { LATC1 = 1; } while(0)
#define DOWN_Out_SetLow()   do { LATC1 = 0; } while(0)
#define DOWN_Out_Toggle()   do { LATC1 = ~LATC1; } while(0)
#define DOWN_Out_GetValue()         RC1
#define DOWN_Out_SetDigitalInput()    do { TRISC1 = 1; } while(0)
#define DOWN_Out_SetDigitalOutput()   do { TRISC1 = 0; } while(0)

#define DOWN_Out_SetPullup()    do { WPUC1 = 1; } while(0)
#define DOWN_Out_ResetPullup()   do { WPUC1 = 0; } while(0)
#define DOWN_Out_SetAnalogMode()   do { ANSC1 = 1; } while(0)
#define DOWN_Out_SetDigitalMode()   do { ANSC1 = 0; } while(0)
// get/set LEFT_Out aliases
#define LEFT_Out_TRIS               TRISC2
#define LEFT_Out_LAT                LATC2
#define LEFT_Out_PORT               RC2
#define LEFT_Out_WPU                WPUC2
#define LEFT_Out_ANS                ANSC2
#define LEFT_Out_SetHigh()    do { LATC2 = 1; } while(0)
#define LEFT_Out_SetLow()   do { LATC2 = 0; } while(0)
#define LEFT_Out_Toggle()   do { LATC2 = ~LATC2; } while(0)
#define LEFT_Out_GetValue()         RC2
#define LEFT_Out_SetDigitalInput()    do { TRISC2 = 1; } while(0)
#define LEFT_Out_SetDigitalOutput()   do { TRISC2 = 0; } while(0)

#define LEFT_Out_SetPullup()    do { WPUC2 = 1; } while(0)
#define LEFT_Out_ResetPullup()   do { WPUC2 = 0; } while(0)
#define LEFT_Out_SetAnalogMode()   do { ANSC2 = 1; } while(0)
#define LEFT_Out_SetDigitalMode()   do { ANSC2 = 0; } while(0)
// get/set RIGHT_Out aliases
#define RIGHT_Out_TRIS               TRISC3
#define RIGHT_Out_LAT                LATC3
#define RIGHT_Out_PORT               RC3
#define RIGHT_Out_WPU                WPUC3
#define RIGHT_Out_ANS                ANSC3
#define RIGHT_Out_SetHigh()    do { LATC3 = 1; } while(0)
#define RIGHT_Out_SetLow()   do { LATC3 = 0; } while(0)
#define RIGHT_Out_Toggle()   do { LATC3 = ~LATC3; } while(0)
#define RIGHT_Out_GetValue()         RC3
#define RIGHT_Out_SetDigitalInput()    do { TRISC3 = 1; } while(0)
#define RIGHT_Out_SetDigitalOutput()   do { TRISC3 = 0; } while(0)

#define RIGHT_Out_SetPullup()    do { WPUC3 = 1; } while(0)
#define RIGHT_Out_ResetPullup()   do { WPUC3 = 0; } while(0)
#define RIGHT_Out_SetAnalogMode()   do { ANSC3 = 1; } while(0)
#define RIGHT_Out_SetDigitalMode()   do { ANSC3 = 0; } while(0)
// get/set START_Out aliases
#define START_Out_TRIS               TRISC4
#define START_Out_LAT                LATC4
#define START_Out_PORT               RC4
#define START_Out_WPU                WPUC4
#define START_Out_SetHigh()    do { LATC4 = 1; } while(0)
#define START_Out_SetLow()   do { LATC4 = 0; } while(0)
#define START_Out_Toggle()   do { LATC4 = ~LATC4; } while(0)
#define START_Out_GetValue()         RC4
#define START_Out_SetDigitalInput()    do { TRISC4 = 1; } while(0)
#define START_Out_SetDigitalOutput()   do { TRISC4 = 0; } while(0)

#define START_Out_SetPullup()    do { WPUC4 = 1; } while(0)
#define START_Out_ResetPullup()   do { WPUC4 = 0; } while(0)

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    GPIO and peripheral I/O initialization
 * @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);

#endif // PIN_MANAGER_H
/**
 End of File
*/